---

marp: true
theme: default
markdown.marp.enableHtml: true
paginate: true

---

# Utiliser Markdown et Mermaid pour vos notes, docs et diagrammes

Olivier ZIMMERMANN (LPSC Grenoble)

Journée AlpesVIEW 2025 - 23 septembre 2025 - G2ELab

---

## Un langage de balisage léger

"Le principal objetctif de la syntaxe Markdown est de préserver au maximum la lisibilité du texte. Le texte brut d'un document formaté avec Markdown devrait pourvoir être publié tel quel, sans qu'on ait l'impression d'y voir des instructions de formattage" ([*J. Gruber*](http://daringfireball.net/projects/markdown/))

---

## Pris en charge par GitLab

<img src="files\gitlab.png">

---

## Comment faire sous Windows

| Outil(s) | Edition | Rendu |
|-|-|-|
| Bloc-notes | ++ | ~ |
| Notepad++ + plugin [NppMarkdownPanel (Moritz Hzy)](https://github.com/mohzy83/NppMarkdownPanel) | ++ | ++ |
| Brave [^1] + plugin [Markdown Viewer (Simeon Velichkov)](https://chromewebstore.google.com/detail/markdown-viewer/ckkdlimhmcjmikdlpkmbgfkaikojcbjk) | N/A | +++ |
| Explorer + [PowerToys (MS)](https://apps.microsoft.com/detail/xp89dcgq3k6vld?hl=fr-FR&gl=FR) | N/A | + |
| VSCode + plugin [Markdown Preview Mermaid Support (Matt Bierner)](https://marketplace.visualstudio.com/items?itemName=bierner.markdown-mermaid) | ++ | +++ |
| VSCode + plugin [Marp](https://marp.app/)| ++ | + |

[^1]: (Un autre navigateur basé sur Chromium qui ne me sert qu'à ça)

---

## Les diagrammes ⭐ Mermaid ⭐

```mermaid
stateDiagram-v2
  [*]-->Welcome
  Welcome-->Good_Bye
  Welcome-->Have_a_drink!
```

<script type="module">
  import mermaid from 'https://cdnjs.cloudflare.com/ajax/libs/mermaid/10.4.0/mermaid.min.js';
  mermaid.initialize({ startOnLoad: true });
</script>

<div class="mermaid">
stateDiagram-v2
  [*]-->Welcome
  Welcome-->Good_Bye
  Welcome-->Have_a_drink!
</div>

---

On peut insérer du HTML pour tout ce qui est plus élaboré (ex. diagramme mermaid dans un rendu en présentation avec *Marp*).

```js
<script type="module">
  import mermaid from 'https://cdnjs.cloudflare.com/ajax/libs/mermaid/10.4.0/mermaid.min.js';
  mermaid.initialize({ startOnLoad: true });
</script>

<div class="mermaid">
stateDiagram-v2
  [*]-->Welcome
  Welcome-->Good_Bye
  Welcome-->Have_a_drink!
</div>
```

<script type="module">
  import mermaid from 'https://cdnjs.cloudflare.com/ajax/libs/mermaid/10.4.0/mermaid.min.js';
  mermaid.initialize({ startOnLoad: true });
</script>

<div class="mermaid">
stateDiagram-v2
  [*]-->Welcome
  Welcome-->Good_Bye
  Welcome-->Have_a_drink!
</div>

---

## Liens utiles (1)

- https://markdownguide.offshoot.io/cheat-sheet/
  syntaxe étendue
- https://spec.commonmark.org/
  syntaxe minimaliste (*une* spécification détaillée)
- https://daringfireball.net/projects/markdown/syntax
  syntaxe minimaliste (J. Gruber)
- https://fr.wikipedia.org/wiki/Markdown
  Markdown
- https://fr.wikipedia.org/wiki/Langage_de_balisage_l%C3%A9ger
  *Lightweight Markup Language* (LML)

---

## Liens utiles (2)

- https://mermaid.live/
  Edition de diagrammes Mermaid en ligne
